#ifndef PANEL_H
#define PANEL_H

#include<QWidget>
#include<QMutex>

class Panel : public QWidget 
{
	Q_OBJECT

	public:
		Panel(QMutex *mux, QWidget* parent = 0);
		void increment();
		void decrement();
		void reset();
	
	public slots:
		void changeSynchronization();


	protected:
		virtual void paintEvent(QPaintEvent *event);

	private:
		unsigned int begin;
		const static unsigned int size = 21;
		volatile bool synchronization;
		QMutex *mutex;
};

#endif
