#include"Panel.h"
#include<QPainter>

Panel::Panel(QMutex *mux, QWidget* parent):QWidget(parent)
{
	synchronization = false;
	mutex=mux;
	begin=10;
	setFixedSize(510,200);
}

void Panel::changeSynchronization()
{
	synchronization=!synchronization;
}

void Panel::reset()
{
	begin = 10;
}

void Panel::increment()
{
	begin = (begin+1) % size;
}

void Panel::decrement()
{
	begin = (begin+(size-1)) % size;
}

void Panel::paintEvent(QPaintEvent *event)
{
	if(synchronization)
		mutex->lock();
        (void)event;
        QPainter painter(this);
	painter.setRenderHint(QPainter::Antialiasing, true);
	painter.setPen(QPen(Qt::black,1,Qt::SolidLine,Qt::RoundCap));
	for(int i=0;i<500;i+=25) {
		if(static_cast<unsigned int>(i)>=begin*25)
			painter.setBrush(QBrush(Qt::green,Qt::SolidPattern));
		else
			painter.setBrush(QBrush(Qt::red,Qt::SolidPattern));
		painter.drawRoundedRect(10+i,90,20,20,1.0,1.0);
	}
	if(synchronization)
		mutex->unlock();
}
