#include "IncThread.h"
#include<pthread.h>

IncThread::IncThread(QMutex *m, Panel *p1, Panel  *p2)
{
	pl1 = p1;
	pl2 = p2;
	mutex = m;
	synchronization=false;
	oneCore=false;
	finish = false;
}

IncThread::~IncThread()
{
	finish=true;
}

void IncThread::stop()
{
	finish=true;
}

void IncThread::enable()
{
	finish=false;
}

void IncThread::changeSynchronization()
{
	synchronization=!synchronization;
}

void IncThread::setOneCore() 
{
	cpu_set_t cpuset;

	if(!oneCore) {
		CPU_ZERO(&cpuset);
		CPU_SET(1,&cpuset);
		pthread_setaffinity_np((pthread_t)QThread::currentThreadId(),sizeof(cpu_set_t),&cpuset);
	} else {
		CPU_ZERO(&cpuset);
		for(int i=0;i<4;i++)
			CPU_SET(i,&cpuset);
		pthread_setaffinity_np((pthread_t)QThread::currentThreadId(),sizeof(cpu_set_t),&cpuset);
	}
	oneCore=!oneCore;
}

void IncThread::run()
{
	if(synchronization) 
		mutex->lock();
	pl1->reset();
	pl2->reset();
	if(synchronization)
		mutex->unlock();

	while(!finish) {
		if(synchronization)
			mutex->lock();
		pl1->increment();
		pl2->increment();
		if(synchronization)
			mutex->unlock();
	}
}
