#include "DecThread.h"
#include<pthread.h> 

DecThread::DecThread(QMutex *m, Panel *p1, Panel  *p2)
{
	pl1 = p1;
	pl2 = p2;
	mutex = m;
	oneCore = false;
	synchronization=false;
	finish = false;
}

DecThread::~DecThread()
{
	finish=true;
}

void DecThread::stop()
{
	finish=true;
}

void DecThread::enable() 
{
	finish=false;
}

void DecThread::changeSynchronization()
{
	synchronization=!synchronization;
}

void DecThread::setOneCore()
{
	cpu_set_t cpuset;

	if(!oneCore) {

		CPU_ZERO(&cpuset);
		CPU_SET(1,&cpuset);
		pthread_setaffinity_np((pthread_t)QThread::currentThreadId(),sizeof(cpu_set_t),&cpuset);
	} else {
		CPU_ZERO(&cpuset);
		for(int i=0;i<4;i++) 
			CPU_SET(i,&cpuset);
		pthread_setaffinity_np((pthread_t)QThread::currentThreadId(),sizeof(cpu_set_t),&cpuset);
	}
	oneCore=!oneCore;
}

void DecThread::run()
{
	if(synchronization) 
		mutex->lock();
	pl1->reset();
	pl2->reset();
	if(synchronization) 
		mutex->unlock();

	while(!finish) {
		if(synchronization) 
			mutex->lock();
		pl1->decrement();
		pl2->decrement();
		if(synchronization)
			mutex->unlock();
	}
}
