#include"Controller.h"
#include<QTextCodec>

Controller::Controller(Panel *pl1, Panel *pl2, IncThread *it, DecThread *dt, QWidget *parent):QWidget(parent)
{
	ith = it;
	dth = dt;
	p1 = pl1;
	p2 = pl2;
	setFixedSize(510,50);
	starter.setParent(this);
	starter.setText(tr("&Start"));
	cb.setParent(this);
	cb.setText(tr("Syn&chronizacja"));
	oc.setParent(this);
	QTextCodec::codecForName("UTF-8");
	oc.setText(tr("&Jeden rdzeń"));
	QObject::connect(&starter,SIGNAL(clicked()),this,SLOT(runThreads()));
	QObject::connect(&cb,SIGNAL(stateChanged(int)),ith,SLOT(changeSynchronization()));
	QObject::connect(&cb,SIGNAL(stateChanged(int)),dth,SLOT(changeSynchronization()));
	QObject::connect(&cb,SIGNAL(stateChanged(int)),p1,SLOT(changeSynchronization()));
	QObject::connect(&cb,SIGNAL(stateChanged(int)),p2,SLOT(changeSynchronization()));
	QObject::connect(&oc,SIGNAL(stateChanged(int)),ith,SLOT(setOneCore()));
	QObject::connect(&oc,SIGNAL(stateChanged(int)),dth,SLOT(setOneCore()));
	QObject::connect(&timer,SIGNAL(timeout()),this,SLOT(repaintPanels()));
	layout.addWidget(&starter);
	layout.addWidget(&cb);
	layout.addWidget(&oc);
	setLayout(&layout);
	show();
	starter.show();
	timer.start(100);
}

void Controller::repaintPanels()
{
	p1->update();
	p2->update();
}

void Controller::runThreads()
{
	if(ith->isRunning()&&dth->isRunning()) {
		ith->stop();
		dth->stop();
		starter.setText("&Start");
		cb.setEnabled(true);
		oc.setEnabled(true);
	} else {
		cb.setEnabled(false);
		oc.setEnabled(false);
		ith->enable();
		ith->start(QThread::LowPriority);
		dth->enable();
		dth->start(QThread::LowPriority);
		starter.setText("&Stop");
	}
}	
