#include"CentralWidget.h"
#include<QTextCodec>

CentralWidget::CentralWidget(QWidget *parent):QWidget(parent)
{
	p1 = new Panel(&mutex,this);
	p2 = new Panel(&mutex,this);
	it = new IncThread(&mutex,p1,p2);
	dt = new DecThread(&mutex,p1,p2);
	ctrl = new Controller(p1,p2,it,dt,this);
	layout = new QVBoxLayout;
	layout->addWidget(ctrl);
	layout->addWidget(p1);
	layout->addWidget(p2);
	setLayout(layout);
	QTextCodec::codecForName("UTF-8");
	setWindowTitle(tr("Synchronizacja wątków"));
	setFixedSize(530,400);
	show();
}

CentralWidget::~CentralWidget()
{
	delete layout;
	delete ctrl;
	delete dt;
	delete it;
	delete p2;
	delete p1;
}

void CentralWidget::closeEvent(QCloseEvent *event)
{
	if(!dt->isRunning()&&!it->isRunning())
		event->accept();
	else
		event->ignore();
}

