const uint8_t LED_PIN = 8;
const uint8_t BUTTON_PIN = 2;

int led_state = LOW;

void change_led_state() {
  noInterrupts();
  static uint64_t last_debounce_time = 0;
  uint64_t current_time = millis();
  if (current_time - last_debounce_time > 200) {
    led_state = !led_state;
     digitalWrite(LED_PIN, led_state);
  }   
  last_debounce_time = current_time;
  interrupts();
}

void setup() {
  Serial.begin(9660);
  pinMode(LED_PIN, OUTPUT);
  pinMode(BUTTON_PIN, INPUT);
  int interrupt_pin = digitalPinToInterrupt(BUTTON_PIN);
  if (interrupt_pin == -1)
    Serial.println("Not a valid interrupt pin!");
  else {
    noInterrupts();
    attachInterrupt(interrupt_pin, change_led_state, CHANGE);
    interrupts();
  }
}

void loop() {
  Serial.println("Systemy operacyjne 1");
  delay(5000); 
}
