package pl.kielce.tu.pages;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

import java.time.Duration;

public class ShopLoginPage {
    private final WebDriver driver;

    public ShopLoginPage(WebDriver driver) {
        this.driver = driver;
    }

    public void goToLoginPage() {
        driver.get("https://www.saucedemo.com/");
    }

    public String getTitle() {
        return driver.getTitle();
    }

    public String getRandomUserName() {
        WebElement usersList = driver.findElement(By.xpath("//div[@id=\"login_credentials\"]"));
        String[] users = usersList.getText().split("\n");
        //return users[new Random().nextInt(users.length-1)+1];
        return users[1];
    }

    public String getPassword() {
        WebElement password = driver.findElement(By.xpath("//div[@class=\"login_password\"]"));
        return password.getText().split("\n")[1];
    }

    public void enterUserName(String userName) {
        WebElement loginField = driver.findElement(By.xpath("//input[@id=\"user-name\"]"));
        loginField.sendKeys(userName);
    }

    public void enterPassword(String password) {
        WebElement loginField = driver.findElement(By.xpath("//input[@id=\"password\"]"));
        loginField.sendKeys(password);
    }

    public void clickLogin() {
        driver.findElement(By.xpath("//input[@id=\"login-button\"]")).click();
    }

}
