package pl.kielce.tu.pages;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class ProductPage {
    private final WebDriver driver;

    public ProductPage(WebDriver driver) {
        this.driver = driver;
    }

    public String getName() {
        WebElement item = driver.findElement(By.xpath("//div[@data-test=\"inventory-item-name\"]"));
        return item.getText();
    }

    public String getPrice() {
        WebElement item = driver.findElement(By.xpath("//div[@data-test=\"inventory-item-price\"]"));
        return item.getText();
    }

    public void addToCart() {
        WebElement item = driver.findElement(By.xpath("//button[@id=\"add-to-cart\"]"));
        item.click();
    }

    public void backToMainPage() {
        WebElement item = driver.findElement(By.xpath("//button[@id=\"back-to-products\"]"));
        item.click();
    }

}
