package pl.kielce.tu.pages;

import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.FluentWait;
import org.openqa.selenium.support.ui.Wait;

import java.time.Duration;

public class Menu {
    private final WebDriver driver;

    public Menu(WebDriver driver) {
        this.driver = driver;
    }

    public Menu openMenu() {
        Wait<WebDriver> wait = new FluentWait<>(driver)
                .withTimeout(Duration.ofSeconds(30))
                .pollingEvery(Duration.ofMillis(500))
                .ignoring(NoSuchElementException.class);
        WebElement menu = wait.until(driver -> driver.findElement(By.xpath("//button[@id=\"react-burger-menu-btn\"]")));
        menu.click();
        return this;
    }

    public void clickLogout() {
        WebElement logoutOption = driver.findElement(By.xpath("//a[@id=\"logout_sidebar_link\"]"));
        logoutOption.click();
    }

}
