package pl.kielce.tu.pages;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;

public class CartPage {

    private final WebDriver driver;

    public CartPage(WebDriver driver) {
        this.driver = driver;
    }

    public CartPage clickCheckoutButton() {
        driver.findElement(By.xpath("//button[@id=\"checkout\"]")).click();
        return this;
    }

    public CartPage fillForm(String firstName, String lastName, String postalCode) {
        driver.findElement(By.xpath("//input[@id=\"first-name\"]")).sendKeys(firstName);
        driver.findElement(By.xpath("//input[@id=\"last-name\"]")).sendKeys(lastName);
        driver.findElement(By.xpath("//input[@id=\"postal-code\"]")).sendKeys(postalCode);
        driver.findElement(By.xpath("//input[@id=\"continue\"]")).click();
        return this;
    }

    public void clickFinish() {
        driver.findElement(By.xpath("//button[@id=\"finish\"]")).click();
    }

    public String getFinalMessage() {
        return driver.findElement(By.xpath("//h2[@class=\"complete-header\"]")).getText();
    }

}
