package pl.kielce.tu.pages;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;

public class CartIcon {
    private final WebElement cart;

    public CartIcon(WebDriver driver) {
        cart = driver.findElement(By.xpath("//div[@id=\"shopping_cart_container\"]"));
    }

    public void clickCart() {
        cart.click();
    }

    public boolean checkIfBadgePresent() {
        return null!=getBadge();
    }

    public int getItemsNumber() {
        return Integer.parseInt(getBadge().getText());
    }


    private WebElement getBadge() {
        return cart.findElement(By.xpath("//span[@data-test=\"shopping-cart-badge\"]"));
    }


}
