import javafx.scene.Node;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import org.junit.jupiter.api.*;
import org.testfx.api.FxAssert;
import org.testfx.framework.junit5.ApplicationTest;
import org.testfx.matcher.control.LabeledMatchers;
import pl.kielce.tu.GUISimpleApplication;

@TestMethodOrder(MethodOrderer.MethodName.class)
public class GUISimpleApplicationTest extends ApplicationTest {

    @BeforeEach
    public void setUp() throws Exception{
        launch(GUISimpleApplication.class);
    }

    @Test
    public void testButtonLabel() {
        FxAssert.verifyThat(".button", LabeledMatchers.hasText("Add"));
    }

    @Test
    public void testThatTextFieldExists() {
        Node node = lookup(".text-field").queryAll().iterator().next();
        Assertions.assertNotNull(node, "No node of .text-field class found!");
        Assertions.assertInstanceOf(TextField.class, node, "The node is not TextField");
    }

    @Test
    public void testThatTextAreaExists() {
        Node node = lookup(".text-area").queryAll().iterator().next();
        Assertions.assertNotNull(node, "No node of .text-area class found!");
        Assertions.assertInstanceOf(TextArea.class, node, "The node is not TextArea");
    }

    @Test
    public void testFunctionality() {
        final String text = "The quick brown fox jumped over the lazy dog.";
        TextField input = (TextField) lookup(".text-field").queryAll().iterator().next();
        input.setText(text);
        clickOn(".button");
        TextArea display = (TextArea) lookup(".text-area").queryAll().iterator().next();
        Assertions.assertEquals(text,display.getText().trim());
    }
    @RepeatedTest(100)
    public void testMoreThanOnce() {
        final String text = "The quick brown fox jumped over the lazy dog.";
        TextField input = (TextField) lookup(".text-field").queryAll().iterator().next();
        TextArea display = (TextArea) lookup(".text-area").queryAll().iterator().next();
        input.setText(text);
        clickOn(".button");
        Assertions.assertEquals(text,display.getText().trim());
        display.clear();
    }

}
