import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import pl.kielce.tu.RPN;

import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.params.provider.Arguments.arguments;

public class RPNTest {
    private static final String ERROR_MESSAGE = "Error processing the expression: ";
    private final static RPN rpn = new RPN();

    public static Stream<Arguments> provideData() {
        return Stream.of(
                arguments("","[]"),
                arguments("0","[0]"),
                arguments("5","[5]"),
                arguments("2.5*2.5","[2.5, 2.5, *]"),
                arguments("2.5+2.5","[2.5, 2.5, +]"),
                arguments("2.55+2.55","[2.55, 2.55, +]"),
                arguments("(23+5)*3","[23, 5, +, 3, *]"),
                arguments("23*5+3/4","[23, 5, *, 3, 4, /, +]"),
                arguments("(23+8)*(5+6)","[23, 8, +, 5, 6, +, *]"),
                arguments("(35+25)/(23-90)","[35, 25, +, 23, 90, -, /]"),
                arguments("25/(23-90)","[25, 23, 90, -, /]"),
                arguments("3*(2+(40-3)*7)+5","[3, 2, 40, 3, -, 7, *, +, *, 5, +]"),
                arguments("(3.5+2.5)*1.4", "[3.5, 2.5, +, 1.4, *]"),
                arguments("(2.5+1.5)*4","[2.5, 1.5, +, 4, *]")
                );
    }
    @ParameterizedTest
    @MethodSource("provideData")
    public void testRPN(String expression, String expectedResult) {
        assertEquals(expectedResult,rpn.getRPN(expression).toString(),ERROR_MESSAGE+expression);
    }
}
