import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import pl.kielce.tu.ExpressionsEvaluator;
import pl.kielce.tu.RPN;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.mockito.Mockito.*;

@ExtendWith(MockitoExtension.class)
public class ExpressionsEvaluatorWithSpyTest {
    private final RPN spyRPN = spy(new RPN());
    private final ExpressionsEvaluator evaluator = new ExpressionsEvaluator(spyRPN);
    private static final String ERROR_MESSAGE = "Evaluation error for the expression: ";
    private static final double EPSILON = 0.00001;

    @Test
    public void testEvaluator() {
        String expression = "(23+8)*(5+6)";
        double result = 341.0;
        assertEquals(result,evaluator.calculate(expression),EPSILON,ERROR_MESSAGE+expression);
        verify(spyRPN,atLeastOnce()).getRPN(expression);
    }
}
