import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;
import pl.kielce.tu.ExpressionsEvaluator;
import pl.kielce.tu.RPN;

import java.util.LinkedList;
import java.util.List;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertNotNull;
import static org.mockito.Mockito.when;

@ExtendWith(MockitoExtension.class)
public class ExpressionsEvaluatorWithMockTest {
    @Mock
    private RPN rpn;
    private static final String ERROR_MESSAGE = "Evaluation error for the expression: ";
    private static final double EPSILON = 0.00001;

    @Test
    public void testEvaluatorWithSimpleAddition() {
        String expression = "2.5+2.5";
        double result = 5.0;
        assertNotNull(rpn);
        when(rpn.getRPN("2.5+2.5")).thenReturn(new LinkedList<>(List.of("2.5","2.5","+")));
        ExpressionsEvaluator evaluator = new ExpressionsEvaluator(rpn);
        assertEquals(result,evaluator.calculate(expression),EPSILON,ERROR_MESSAGE+expression);
    }

    @Test
    public void testEvaluatorWithNullString() {
        String expression = "";
        double result = 0;
        assertNotNull(rpn);
        when(rpn.getRPN("")).thenReturn(new LinkedList<>());
        ExpressionsEvaluator evaluator = new ExpressionsEvaluator(rpn);
        assertEquals(result,evaluator.calculate(expression),EPSILON,ERROR_MESSAGE+expression);
    }
}
