import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import pl.kielce.tu.ExpressionsEvaluator;
import pl.kielce.tu.RPN;

import java.util.stream.Stream;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.params.provider.Arguments.arguments;
public class ExpressionsEvaluatorTest {
    private static final RPN rpn = new RPN();
    private static final ExpressionsEvaluator evaluator = new ExpressionsEvaluator(rpn);
    private static final String ERROR_MESSAGE = "Evaluation error for the expression: ";
    private static final double EPSILON = 0.00001;

    public static Stream<Arguments> provideData() {
        return Stream.of(
                arguments("",0.0),
                arguments("0",0.0),
                arguments("5",5.0),
                arguments("2.5*2.5",6.25),
                arguments("2.5+2.5",5.0),
                arguments("2.55+2.55",5.1),
                arguments("3.36*2.41",8.0976),
                arguments("5-2",3.0),
                arguments("(23+5)*3",84.0),
                arguments("23*5+3/4",115.75),
                arguments("(23+8)*(5+6)",341.0),
                arguments("(35+25)/(23-90)",-0.8955223880597015),
                arguments("25/(23-90)",-0.373134328358209),
                arguments("3*(2+(40-3)*7)+5",788.0)
        );
    }

    @ParameterizedTest
    @MethodSource("provideData")
    public void testEvaluator(String expression, double result) {
        assertEquals(result,evaluator.calculate(expression),EPSILON,ERROR_MESSAGE+expression);
    }
}
