package pl.kielce.tu;

import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RPN {

    private LinkedList<String> parseExpression(String infix) {
        LinkedList<String> list = new LinkedList<>();
        String regex = "[()]|[+-/*]|\\d*[.]?\\d*";
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(infix);
        while (matcher.find())
            list.add(matcher.group());
        list.removeLast();
        return list;

    }

    private Integer getPrecedence(String term) {
        int precedence = 0;
        if (term.equals("*") || term.equals("/"))
            precedence = 2;
        if (term.equals("+") || term.equals("-"))
            precedence = 1;
        return precedence;
    }

    private Boolean isOperator(String term) {
        return term.equals("+") || term.equals("-") || term.equals("*") || term.equals("/");
    }

    public LinkedList<String> getRPN(String infix) {
        LinkedList<String> rpnExpression = new LinkedList<>(), stack = new LinkedList<>();
        LinkedList<String> expression = parseExpression(infix);

        while (!expression.isEmpty()) {
            String top = expression.removeFirst();
            boolean argument = true;

            if (top.equals("(")) {
                argument = false;
                stack.push(top);
            }

            if (top.equals(")")) {
                argument = false;
                while (!stack.isEmpty()) {
                    if (!stack.peekFirst().equals("("))
                        rpnExpression.add(stack.pop());
                    else {
                        stack.pop();
                        break;
                    }
                }
            }

            if (isOperator(top)) {
                while (!(stack.isEmpty() ||"( ".equals(stack.peekFirst())))
                    if (getPrecedence(stack.peekFirst()) >= getPrecedence(top))
                        rpnExpression.add(stack.pop());
                    else
                        break;
                stack.push(top);
                argument = false;
            }

            if (argument)
                rpnExpression.add(top);
        }

        while (!stack.isEmpty())
            rpnExpression.add(stack.pop());

        return rpnExpression;

    }

    public static void main(String[] args) {
        RPN test = new RPN();
        String[] params = {"(23+5)*3", "23*5+3/4", "(23+8)*(5+6)",
                "(35+25)/(23-90)", "25/(23-90)", "3*(2+(40-3)*7)+5"};
        for (String x : params)
            System.out.println(x + " => " + test.getRPN(x));
    }

}
