package pl.kielce.tu;

import java.util.LinkedList;

public class ExpressionsEvaluator {
    private final LinkedList<Double> stack = new LinkedList<>();
    private final RPN rpn;

    public ExpressionsEvaluator(RPN rpn) {
        this.rpn = rpn;
    }

    private void add() {
        Double argument1 = stack.pop(),
                argument2 = stack.pop();
        stack.push(argument1 + argument2);
    }

    private void subtract() {
        Double argument1 = stack.pop(), argument2 = stack.pop();
        stack.push(argument2 - argument1);
    }

    private void multiply() {
        Double argument1 = stack.pop(), argument2 = stack.pop();
        stack.push(argument1*argument2);
    }

    private void divide() {
        Double argument1 = stack.pop(), argument2 = stack.pop();
        stack.push(argument2/argument1);
    }

    public Double calculate(String expr) {
        LinkedList<String> RPNExpr = rpn.getRPN(expr);
        while (!RPNExpr.isEmpty()) {
            String str = RPNExpr.removeFirst();
            switch (str) {
                case "+":
                    add();
                    break;
                case "-":
                    subtract();
                    break;
                case "*":
                    multiply();
                    break;
                case "/":
                    divide();
                    break;
                default:
                    stack.push(Double.valueOf(str));
            }
        }
        return stack.isEmpty()?0.0:stack.pop();
    }

    public static void main(String[] args) {
        RPN rpn = new RPN();
        ExpressionsEvaluator test = new ExpressionsEvaluator(rpn);
        String[] params = {"5-2","(23+5)*3","23*5+3/4","(23+8)*(5+6)",
                "(35+25)/(23-90)","25/(23-90)","3*(2+(40-3)*7)+5"};
        for(String x: params)
            System.out.println(x + " = " + test.calculate(x));
    }

}

