#include<stdio.h>
#include<math.h>

void get_abc_parameters(float *a, float *b, float *c)
{
    puts("Please enter the coefficients of the quadratic equation:");
    do {
        printf("a= ");
        scanf("%f",a);
        if(*a==0.0)
            puts("The vale of \"a\" coefficient mustn't be zero!");
    } while(*a==0.0);
    printf("b= ");
    scanf("%f",b);
    printf("c= ");
    scanf("%f",c);
}

float calculate_delta(float a, float b, float c)
{
    return b*b-4*a*c;
}

int signum(float number)
{
    return (number<0.0) ? -1 : 1;
}


float calculate_q(float b, float delta)
{
    return -0.5*(b+signum(b)*sqrt(delta));
}

float calculate_root(float a, float q)
{
    return q/a;
}

void calculate_roots(float a, float c, float q, float *x1, float *x2)
{
    *x1=q/a;
    *x2=c/q;
}

int main(void)
{

    float a=0.0,b=0.0,c=0.0;
    get_abc_parameters(&a,&b,&c);
    float delta = calculate_delta(a,b,c);
    if(delta==0.0) {
        float q = calculate_q(b,delta);
        printf("The equation has a single root %.10f\n",
             calculate_root(a,q));
     }
     if(delta>0.0) {
            float q = calculate_q(b,delta);
            float x1=0.0, x2=0.0;
            calculate_roots(a,c,q,&x1,&x2);
            printf("The functions has two roots - x1:\
%.10f, x2: %.10f\n",x1,x2);
     }
     if(delta<0.0)
        puts("The equation doesn't have real roots.");

    return 0;
}
