﻿using System;
using System.Collections.Generic;
using System.Threading;

namespace SynchroWait
{
    class Program
    {
        static List<Thread> threads = new List<Thread>();
        static readonly int iterations = 5;
        static readonly int threadCount = 10;
        static Random rand = new Random();

        static void Main(string[] args)
        {
            for (int i = 0; i < threadCount; i++)
            {
                var thread = new Thread((o) =>
                {
                    int threadNo = (int)o;
                    Thread.Sleep(rand.Next(1000));
                    Console.WriteLine($"Thread no {threadNo} has started");
                    for (int j = 0; j < iterations; j++)
                    {
                        Console.WriteLine($"Thread no {threadNo} working during iteration no {j}");
                        Thread.Sleep(rand.Next(1000));
                    }
                    Thread.Sleep(rand.Next(1000));
                    Console.WriteLine($"Thread no {threadNo} has finished");
                });
                threads.Add(thread);
                thread.Start(i);
            }

            Console.WriteLine("---------------- we lived to see it -----------------");

            foreach (var w in threads)
            {
                w.Join();
            }

            Console.WriteLine("This is the end, press ENTER...");
            Console.ReadLine();
        }
    }
}
