﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace ProducerConsumer
{
    class Program
    {
        static int counter = 0;
        static readonly int threadCount = 10;
        static readonly int iterations = 10;


        static void Main(string[] args)
        {
            List<Thread> consumentThreads = new List<Thread>();
            //Random rand = new Random(); //random common
            for (int i = 0; i < threadCount; i++)
            {
                var consument = new Thread(() =>
                {
                    //random local seed based on time
                    Random rand = new Random();
                    //random local seed based on thread ID (but Tread ID on ich run is the same)
                    //Random rand = new Random(Thread.CurrentThread.ManagedThreadId); 
                    //random local seed based on thread ID and time
                    //Random rand = new Random(Thread.CurrentThread.ManagedThreadId+(int)DateTime.Now.Ticks);
                    for (int j = 0; j < iterations; j++)
                    {
                        var sleepTime = rand.Next(1000);
                        Console.Write($"{sleepTime} ");
                        Thread.Sleep(sleepTime);
                        Console.WriteLine($"[{counter}] ");
                    }
                });
                consumentThreads.Add(consument);
                consument.Start();
            }
            consumentThreads.ForEach(t => Console.WriteLine($"Thread ID:{t.ManagedThreadId}"));
            Thread producentThread = new Thread(() =>
            {
                Random randW = new Random(Thread.CurrentThread.ManagedThreadId + (int)DateTime.Now.Ticks);
                try
                {
                    while (true)
                    {
                        Thread.Sleep(randW.Next(100));
                        Interlocked.Increment(ref counter);
                    }
                }
                catch (ThreadInterruptedException)
                {
                    Console.WriteLine("\nWriteing thread finished");
                }
            });

            producentThread.Start();

            foreach (var thread in consumentThreads)
            {
                thread.Join();
            }

            producentThread.Interrupt();
            producentThread.Join();

            Console.WriteLine("This is the end, press ENTER...");
            Console.ReadLine();
        }
    }
}
